/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.compat.kubejs;

import com.almostreliable.summoningrituals.recipe.AltarRecipe;
import com.almostreliable.summoningrituals.recipe.component.BlockReference;
import com.almostreliable.summoningrituals.recipe.component.RecipeOutputs;
import com.almostreliable.summoningrituals.recipe.component.RecipeSacrifices;
import com.almostreliable.summoningrituals.util.SerializeUtils;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.ListJS;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;

public class AltarRecipeJS
extends RecipeJS {
    private final RecipeOutputs outputs = new RecipeOutputs();
    private final List<IngredientJS> inputs = new ArrayList<IngredientJS>();
    private final RecipeSacrifices sacrifices = new RecipeSacrifices();
    private IngredientJS catalyst;
    private int recipeTime = 100;
    @Nullable
    private BlockReference blockBelow;
    private AltarRecipe.DAY_TIME dayTime = AltarRecipe.DAY_TIME.ANY;
    private AltarRecipe.WEATHER weather = AltarRecipe.WEATHER.ANY;
    private boolean serialize;

    public void create(ListJS listJS) {
        if (listJS.size() != 1) {
            throw new IllegalArgumentException("missing catalyst");
        }
        this.catalyst = IngredientJS.of((Object)listJS.get(0));
        this.serialize = true;
    }

    public void deserialize() {
    }

    public void serialize() {
        if (!this.serialize) {
            return;
        }
        this.json = new JsonObject();
        this.json.add("catalyst", this.catalyst.toJson());
        this.json.add("outputs", (JsonElement)this.outputs.toJson());
        JsonArray inputsArray = new JsonArray();
        this.inputs.forEach(i -> inputsArray.add(i.toJson()));
        if (!inputsArray.isEmpty()) {
            if (inputsArray.size() == 1) {
                this.json.add("inputs", inputsArray.get(0));
            } else {
                this.json.add("inputs", (JsonElement)inputsArray);
            }
        }
        if (!this.sacrifices.isEmpty()) {
            this.json.add("sacrifices", this.sacrifices.toJson());
        }
        if (this.recipeTime != 100) {
            this.json.addProperty("recipe_time", (Number)this.recipeTime);
        }
        if (this.blockBelow != null) {
            this.json.add("block_below", this.blockBelow.toJson());
        }
        if (this.dayTime != AltarRecipe.DAY_TIME.ANY) {
            this.json.addProperty("day_time", this.dayTime.name());
        }
        if (this.weather != AltarRecipe.WEATHER.ANY) {
            this.json.addProperty("weather", this.weather.name());
        }
        ConsoleJS.SERVER.debug((Object)("Altar Recipe: " + this.json.toString()));
    }

    public AltarRecipeJS itemOutput(RecipeOutputs.ItemOutputBuilder itemOutput) {
        this.outputs.add(itemOutput.build());
        return this;
    }

    public AltarRecipeJS mobOutput(RecipeOutputs.MobOutputBuilder entityOutput) {
        this.outputs.add(entityOutput.build());
        return this;
    }

    public AltarRecipeJS input(IngredientJS ... ingredients) {
        for (IngredientJS ingredient : ingredients) {
            if (ingredient.isEmpty()) {
                throw new IllegalArgumentException("ingredient is empty");
            }
            this.inputs.add(ingredient);
        }
        return this;
    }

    public AltarRecipeJS sacrificeRegion(int width, int height) {
        this.sacrifices.setRegion(new Vec3i(width, height, width));
        return this;
    }

    public AltarRecipeJS sacrifice(ResourceLocation id, int count) {
        Preconditions.checkNotNull((Object)id);
        this.sacrifices.add(SerializeUtils.mobFromId(id), count);
        return this;
    }

    public AltarRecipeJS sacrifice(ResourceLocation id) {
        Preconditions.checkNotNull((Object)id);
        return this.sacrifice(id, 1);
    }

    public AltarRecipeJS recipeTime(int recipeTime) {
        this.recipeTime = recipeTime;
        return this;
    }

    public AltarRecipeJS blockBelow(ResourceLocation id, JsonObject properties) {
        Preconditions.checkNotNull((Object)id);
        JsonObject blockJson = new JsonObject();
        blockJson.addProperty("block", id.toString());
        blockJson.add("properties", (JsonElement)properties);
        this.blockBelow = BlockReference.fromJson(blockJson);
        return this;
    }

    public AltarRecipeJS blockBelow(ResourceLocation id) {
        return this.blockBelow(id, new JsonObject());
    }

    public AltarRecipeJS dayTime(AltarRecipe.DAY_TIME dayTime) {
        this.dayTime = dayTime;
        return this;
    }

    public AltarRecipeJS weather(AltarRecipe.WEATHER weather) {
        this.weather = weather;
        return this;
    }
}

